/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.jsp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * Specifies the placement of an embedded JSP within the master JSP
 *
 * <p>Usage:</p>
 *
 * <pre><code>&lt;ats:slave />
 **/
public class SlaveTag extends TagSupport {

    public SlaveTag() {

        super();
    }

    public int doEndTag() throws JspTagException {

        HttpServletRequest request =
            (HttpServletRequest) pageContext.getRequest();
        String slavePath =
            (String) request.getAttribute(MasterTag.SLAVE_ATTRIBUTE);

        if (slavePath == null) {
            throw new JspTagException("Slave not found.  " +
                                      "The slave tag is only valid within a master JSP.");
        }

        try {

            pageContext.include(slavePath);

        } catch (Exception e) {

            e.printStackTrace();
            throw new JspTagException(e.getMessage());
        }

        return EVAL_PAGE;
    }
}
