/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.jsp;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * Embeds the current JSP within the body of another JSP.
 *
 * <p>Usage:</p>
 *
 * <pre><code>&lt;acs:master path="path/to/master.jsp" />
 **/
public class MasterTag extends TagSupport {

    static String SLAVE_ATTRIBUTE = "slavePath";

    private String path = null;

    public MasterTag() {

        super();
    }

    public void setPath(String path) {

        this.path = path;
    }

    public int doStartTag() throws JspTagException {

        HttpServletRequest request;
        request = (HttpServletRequest) pageContext.getRequest();

        if (request.getAttribute(SLAVE_ATTRIBUTE) == null) {

            try {

                request.setAttribute(SLAVE_ATTRIBUTE, request.getServletPath());
                pageContext.forward(path);

            } catch (Exception e) {

                e.printStackTrace();
                throw new JspTagException(e.getMessage());
            }
        }

        return SKIP_BODY;
    }

    public void release() {

        this.path = null;
    }
}
