/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.html;

import com.arsdigita.util.CheckedWrapperException;

/**
 * Encapsulates a configuration error. Similar to <a
 * href="http://java.sun.com/xml/jaxp/dist/1.1/docs/api/javax/xml/parsers/ParserConfigurationException.html">SAXParserConfigurationError</a>.
 *
 * <p>This should be rewritten not to extend {@link
 * com.arsdigita.util.CheckedWrapperException} if/when we port our stuff to J2SE
 * 1.4. </p>

 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since 2002-09-09
 * @version $Id: //core-platform/dev/src/com/arsdigita/templating/html/HTMLParserConfigurationException.java#4 $
 **/
public class HTMLParserConfigurationException extends CheckedWrapperException {

    /**
     * Constructor which only takes a message.
     *
     * @param msg a message explaining the cause of this exception
     **/
    public HTMLParserConfigurationException (String msg) {
        super(msg);
    }

    /**
     * Constructor which takes a root cause that this exception will be
     * wrapping.
     **/
    public HTMLParserConfigurationException (Throwable rootCause) {
        super(rootCause);
    }

    /**
     * Constructor which takes a message string and a root cause that this
     * exception will be wrapping.  The message string should be something
     * different than {@link java.lang.Throwable#getMessage()
     * rootCause.getMessage()} would normally provide.
     */
    public HTMLParserConfigurationException (String s, Throwable rootCause) {
        super(s, rootCause);
    }
}
