/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import javax.servlet.http.HttpServletRequest;

/**
 * Generates a pattern for based on the outputType request
 * parameter
 */
public class OutputTypePatternGenerator implements PatternGenerator {
    public String[] generateValues(String key,
                                   HttpServletRequest req) {
        String query = req.getQueryString();
        if (query != null) {
            int typeIndex = query.indexOf("outputType");
            if (typeIndex > -1) {
                int secondaryIndex = query.indexOf("&", typeIndex);
                String type = null;
                if (secondaryIndex > -1) {
                    type = query.substring(typeIndex, secondaryIndex);
                } else {
                    type = query.substring(typeIndex);
                }
                type = type.toLowerCase();
                if (type.indexOf("text/javascript") > -1) {
                    return new String[] { "text-javascript" };
                } else if (type.indexOf("text/html") > -1) {
                    return new String[] { "text-html" };
                } else if (type.indexOf("text/plain") > -1) {
                    return new String[] { "text-plain" };
                }
            }
        }
        
        return new String[] { };
    }
}
