/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;


import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.kernel.SiteNode;

import com.arsdigita.web.Web;
import com.arsdigita.web.Application;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;


/**
 * Generates a set of pattern values based on the application
 * key, eg content-center, content-section.
 */
public class ApplicationPatternGenerator implements PatternGenerator {
    public String[] generateValues(String key,
                                   HttpServletRequest req) {
        final Application app = Web.getContext().getApplication();
        
        if (app != null) {
            return new String[] {
                app.getPackageType().getKey()
            };
        }
        
        SiteNodeRequestContext ctx = (SiteNodeRequestContext)
            DispatcherHelper.getRequestContext(req);
        
        SiteNode node = ctx.getSiteNode();
        
        if (node != null) {
            return new String[] {
                node.getPackageInstance().getType().getKey()
            };
        }
        
        return new String[] {};
    }
}
