/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import com.arsdigita.templating.PatternGenerator;
import com.arsdigita.web.Web;
import com.arsdigita.web.Application;

import javax.servlet.http.HttpServletRequest;

import java.net.URLEncoder;
import java.util.List;
import java.util.ArrayList;

/**
 *  This looks for the current application and will return its OID if
 *  it is available
 */
public class ApplicationOIDPatternGenerator implements PatternGenerator {

    public String[] generateValues(String key,
                                   HttpServletRequest req) {
        Application application = Web.getContext().getApplication();
        if (application != null) {
            String[] oid = new String[1];
            // FR: better URLEncode this
            oid[0] = URLEncoder.encode(application.getOID().toString());
            return oid;
        } else {
            return new String[] {};
        }
    }
}
