/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.search.QuerySpecification;

/**
 * This interface provides the API for retrieving a
 * query specification based on the current state.
 * The ResultsPane component uses an instance of this
 * class to retrieve the query spec and display a list
 * of results
 *
 * @see com.arsdigita.search.ui.QueryComponent
 * @see com.arsdigita.search.ui.ResultsPane
 */
public interface QueryGenerator {
    
    /**
     * Determines whether a query spec currrently exists
     * @return true if a query spec is available
     */
    boolean hasQuery(PageState state);
    
    /**
     * Retrieves the current query spec. This method
     * can only be called if hasQuery(state) returns
     * true.
     * @return the query spec
     */
    QuerySpecification getQuerySpecification(PageState state);

}
