/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.ui;

import com.arsdigita.bebop.PageState;

import com.arsdigita.search.FilterSpecification;


/**
 * This interface provides the API for retrieving a
 * filter specification based on the current state.
 * The BaseQueryComponent uses instances of this
 * interface to build up a list of filters when creating
 * a query specification.
 *
 * @see com.arsdigita.search.ui.BaseQueryComponent
 * @see com.arsdigita.search.ui.QueryGenerator
 */
public interface FilterGenerator {
    
    /**
     * Returns the current filter specification
     * @return a filter specification
     */
    FilterSpecification getFilter(PageState state);
}
