/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;
import com.arsdigita.mimetypes.MimeType;


/**
 *  This is a location for Converters to register with mime types.
 *  This can then be used at run time to take a file and get a String
 *  representation of the contents of that document.
 */
public class ConverterRegistry {

    private static Logger s_log = Logger.getLogger(ConverterRegistry.class);

    private static Map s_converters = new HashMap();

    /**
     *  Initializers should register their converters here.  If two converters
     *  with the same MimeType are registered then the second converter
     *  will be returned with the call to getConverter.  You can clear
     *  a converter for a mime type by passing in a null converter with
     *  with non-null mimetype array.
     *
     *  @pre mimeTypes != null
     */
    public static void registerConverter(Converter converter, 
                                         MimeType[] mimeTypes) {
        Iterator iterator = Arrays.asList(mimeTypes).iterator();
        while (iterator.hasNext()) {
            s_converters.put((MimeType)iterator.next(), converter);
        }
    }


    /**
     *  This will return the appropriate converter, if one has been
     *  registered.  If there is no registered converter then this
     *  will return null.
     */
    public static Converter getConverter(MimeType mimeType) {
        return (Converter)s_converters.get(mimeType);
    }
} 
