/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.converter;

import com.arsdigita.mimetypes.MimeType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

/**
 *  This interface should be implemented by classes that are able to 
 *  take a document and returns the a String representation of the
 *  document's contents.
 */
public interface Converter {
    
    /**
     *  This takes in a document represented as a byte[] and returns
     *  a text representation of that document.
     */
    String convertDocument(InputStream stream) throws ConversionException;

    /**
     *  This takes the document and returns a String containing the contents
     *  of the document.
     */
    String convertDocument(File document) throws FileNotFoundException;

    /** 
     *  This takes in a document represented as a byte[] and returns
     *  a text representation of that document.
     */
    public String convertDocument(byte[] document);

    /**
     *  This returns an array of all MimeTypes that this converter is able
     *  to convert to a String.
     */
    MimeType[] getMimeTypes();
} 
