/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.converter;

import com.arsdigita.mimetypes.MimeType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Iterator;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.util.PDFTextStripper;

/**
 * This class provides the mechanism to perform a conversion from
 * Excel to standard text
 */
public abstract class BaseConverter implements Converter {
    
    private MimeType[] s_types = null;


    /** 
     *  This takes in a document represented as a byte[] and returns
     *  a text representation of that document.
     */
    public String convertDocument(byte[] document) {
        return convertDocument(new ByteArrayInputStream(document));
    }

    /**
     *  This takes the document and returns a String containing the contents
     *  of the document.
     */
    public String convertDocument(File document) throws FileNotFoundException {
        return convertDocument(new FileInputStream(document));
    }

    /**
     *  Returns a string array representing all of the files types
     *  used by the given converter
     */
    protected abstract String[] getFileExtensions();

    /**
     *  This returns an array of all MimeTypes that this converter is able
     *  to convert to a String.
     */
    public MimeType[] getMimeTypes() {
        if (s_types == null) {
            String[] extensions = getFileExtensions();
            s_types = new MimeType[extensions.length];
            for (int i = 0; i < extensions.length; i++) {
                s_types[i] = MimeType.guessMimeType(extensions[i]);
            }
        }
        return s_types;
    }
} 
