/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;


/**
 * This class records the capabilities of a
 * search indexer implemenation.
 */
public class IndexerType {

    public static final IndexerType INTERMEDIA = 
        new IndexerType("intermedia",
                        new ContentType[] {
                            ContentType.RAW,
                            ContentType.XML
                        },
                        new com.arsdigita.search.intermedia.DocumentObserver());
    public static final IndexerType LUCENE =
        new IndexerType("lucene",
                        new ContentType[] {
                            ContentType.TEXT
                        },
                        new com.arsdigita.search.lucene.DocumentObserver());
    
    public static final IndexerType NOOP =
        new IndexerType("noop",
                        new ContentType[] {},
                        null);
                        
    
    private String m_key;
    private ContentType[] m_content;
    private DocumentObserver m_observer;
    
    protected IndexerType(String key,
                          ContentType[] content,
                          DocumentObserver observer) {
        m_key = key;
        m_content = content;
        m_observer = observer;
    }
    
    /**
     * Returns the key for the indexer
     */
    public String getKey() {
        return m_key;
    }
    
    /**
     * Returns the list of content types supported
     * by the indexer
     */
    public ContentType[] getContent() {
        return m_content;
    }
    
    /**
     * Gets the document observer for this indexer
     * @return document observer, or null
     */
    public DocumentObserver getObserver() {
        return m_observer;
    }

    /**
     * Simply returns the indexers key
     * @return the indexers key
     */
    public String toString() {
        return getKey();
    }
    
    /**
     * Two IndexerType objects compare equals
     * if they have the same key
     * @return true if o is an IndexerType and has the same key
     */
    public boolean equals(Object o) {
        if (o instanceof IndexerType) {
            return m_key.equals(((IndexerType)o).getKey());
        }
        return false;
    }
    
    /**
     * Generates a hashcode based on the index key
     * @return a hash code based on the key
     */
    public int hashCode() {
        return m_key.hashCode();
    }
}
