/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.db.*;
import com.arsdigita.installer.*;
import com.arsdigita.util.*;
import com.arsdigita.util.jdbc.*;
import com.arsdigita.util.parameter.*;
import java.io.*;
import java.sql.*;
import java.util.*;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/runtime/SchemaLoader.java#4 $
 */
public final class SchemaLoader {
    private static final Logger s_log = Logger.getLogger(SchemaLoader.class);

    private final String m_script;

    public SchemaLoader(final String script) {
        if (script == null) throw new IllegalArgumentException();

        m_script = script;
    }

    private String interpolatedScriptName() {
        final String url = RuntimeConfig.getConfig().getJDBCURL();
        final int db = DbHelper.getDatabaseFromURL(url);

        return StringUtils.interpolate
            (m_script, "database", DbHelper.getDatabaseDirectory(db));
    }

    public void run(final Connection conn) {
        if (conn == null) throw new IllegalArgumentException();

        SQLLoader.load(conn, interpolatedScriptName());
    }

    public String toString() {
        return interpolatedScriptName();
    }
}
