/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;



/**
 * The Initializer interface is used to prepare the CCM runtime for
 * interaction with the CCM database. This is done in two phases.
 * First the data layer is initialized by loading any
 * object-relational mapping metadata. Secondly the domain layer is
 * initialized by registering any domain metadata. This usually
 * consists of domain object instantiators and observers. It is not
 * safe for CCM code to interact with a CCM database until these
 * phases have been completed.
 *
 * @author Rafael Schloming &lt;rhs@mit.edu&gt;
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/runtime/Initializer.java#5 $
 */
public interface Initializer {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/runtime/Initializer.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    /**
     * Initializes the object-relational mapping metadata by loading
     * PDL resources.
     *
     * @param e A context object with accessors for data
     * initialization
     */
    void init(DataInitEvent e);

    /**
     * Initializes domain-coupling machinery, usually consisting of
     * registering object instantiators and observers.
     *
     * @see com.arsdigita.domain.DomainObjectInstantiator
     * @see com.arsdigita.domain.DomainObjectFactory
     * @see com.arsdigita.domain.GlobalObserver
     * @see com.arsdigita.domain.GlobalObserverManager
     * @param e A context object with accessors for domain
     * initialization
     */
    void init(DomainInitEvent e);

    /**
     * A hook for free-form initialization as existed in the older
     * initialization scheme.
     *
     * @deprecated with no replacement; code that uses this hook
     * should be refactored to use {@link #init(DataInitEvent)} and
     * {@link #init(DomainInitEvent)}
     */
    void init(LegacyInitEvent e);

}
