/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.portal.apportlet;

import com.arsdigita.portal.Portlet;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.portal.PortletRenderer;
import com.arsdigita.web.Application;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import com.arsdigita.web.URL;

/**
 *
 * @author <a href="mailto:jparsons@arsdigita.com">Jim Parsons</a>
 */

public class AppPortlet extends Portlet {

    protected AppPortlet(DataObject dataObject) {
        super(dataObject);
    }

    public Application getParentApplication() {
     
        Application app = (Application)getParentResource(); 
        return app;
    }

    public void setParentApplication(Application app) {
        
        setParentResource(app);
    }

    public AppPortletType getAppPortletType() {
        DataObject dataObject = (DataObject) get("resourceType");

        dataObject.specialize(AppPortletType.BASE_DATA_OBJECT_TYPE);

        AppPortletType portletType = AppPortletType.retrieveAppPortletType(dataObject);

        Assert.assertNotNull(portletType);

        return portletType;
    }

    /**
     * <p>Get the zoom URL associated with a portlet.  Portlet
     * implementors may override this to specify a Portlet's zoom URL.
     * The default implmementation simply finds the
     */

    public String getZoomURL() {

	if (getAppPortletType().isPortalApplication()) {
	    // The parent Application of a portlet is its zoomable counterpart.
	    Application application = getParentApplication();
	    
	    if (application != null) {
		return (URL.getDispatcherPath() + application.getPrimaryURL());
	    } else {
		return null;
	    }
	}  else {
	    return null;
	}
    }

    public PortletRenderer getPortletRenderer() {
        AbstractPortletRenderer portletRenderer = doGetPortletRenderer();

        portletRenderer.setTitle(getTitle());
        portletRenderer.setCellNumber(getCellNumber());
        portletRenderer.setSortKey(getSortKey());
        portletRenderer.setProfile(getProfile());

        String zoomURL = getZoomURL();

        if (zoomURL != null) {
            portletRenderer.setPortletAttribute("applicationLink", zoomURL);
        }

        return portletRenderer;
    }



}
