/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.populate.portlets;

import java.util.List;

import org.apache.log4j.Logger;

import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletType;

/**
 * @author bche
 */
public abstract class AbstractPopulatePortlet implements PopulatePortlet {
        protected Logger s_log = Logger.getLogger(AbstractPopulatePortlet.class);    
        private Portlet m_portlet = null;

	/* (non-Javadoc)
	 * @see com.arsdigita.populate.portlets.PopulatePortlet#createPortlet(com.arsdigita.portal.Portal, int)
	 */
	public void createPortlet(Portal parent, int iCellNumber) {
                Session ses = SessionManager.getSession();
                TransactionContext txn = ses.getTransactionContext();
                txn.beginTxn();
                //refresh the portal view so we can save it
                parent = Portal.retrieve(parent.getOID());
                
		m_portlet = Portlet.createPortlet(getPortletType(), parent);                
                parent.addPortlet(m_portlet, iCellNumber);
                parent.save();
                txn.commitTxn();              
                
                //refresh m_portlet so it is available to other txn's
                m_portlet = Portlet.retrievePortlet(m_portlet.getOID());  
	}

	/* (non-Javadoc)
	 * @see com.arsdigita.populate.portlets.PopulatePortlet#populatePortlet()
	 */
	public abstract void populatePortlet();
	
	/* (non-Javadoc)
	 * @see com.arsdigita.populate.portlets.PopulatePortlet#getPortletType()
	 */
	public abstract PortletType getPortletType();

	/* (non-Javadoc)
	 * @see com.arsdigita.populate.portlets.PopulatePortlet#getPortlet()
	 */
	public Portlet getPortlet() {
		return m_portlet;
	}

}
