/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.populate;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.util.Assert;
import com.arsdigita.util.ResourceManager;

/**
 * @author bche
 */
public class Utilities {
         /**
         * Returns a string guranteed to be unique for every second that this
         * method is run.  Appropriate for using in data fields that require
         * unique values
         * @return a string guranteed to be unique for every second that this
         * method is run.
         */
        public static String getUniqueBaseString() {
            return "_" + (new Date().getTime()/1000) + "_";
        }
        
        /**
         * Returns a string appropriate for using in data fields, based upon
         * the String sSeed.  If sSeed is null or empty, returns a random string.
         * Otherwise, always returns the same string based upon sSeed.
         * @param sSeed the seed String value for constructing the base String 
         * @return a base String based upon sSeed if sSeed is not null or empty.  
         * Otherwise, a random base String.
         */
        public static String getBaseString(String sSeed) {
            if (sSeed == null || sSeed.length() == 0) {
                return getUniqueBaseString();
            } else {
                return "_" + sSeed + "_";
            }            	
        }
        
        /**
         * Returns a binary (image/gif) file
         * @return a binary (image/gif) File
         */
        public static File getBinaryFile() {
            ResourceManager rm = ResourceManager.getInstance();
                   String sWebAppRoot = rm.getWebappRoot().getAbsolutePath();
                   String sImgPath =
                       sWebAppRoot
                       + java.io.File.separator
                       + "assets"
                       + java.io.File.separator
                       + "rhlogo.gif";
                   java.io.File imgFile = new java.io.File(sImgPath);
                   return imgFile;
        }
        
    /**
        * Method makeText.  Returns a text string
        *
        * @param iIndex an index to place at the beginning of the returned string
        * in order to make it unique
        * @return String
        */
       public static String makeText(int iIndex) {
           StringBuffer sb = new StringBuffer(5000);
           for (int i = 0; i < 20; i++) {
               sb.append(iIndex + " All work and no play makes Jack a dull boy.  ");
           }
           return sb.toString();
       }

       /**
        * Method makeText.  Returns a text string 
        *
        * @return String
        */
       public static String makeTextBody() {
           return makeText(0);
       }
        
        /**
         * Method getAdminUser.  Returns a system administrator user
         * @return User
         */
        public static  User getAdminUser() {
            UserCollection uc = User.retrieveAll();
            uc.filter(KernelHelper.getSystemAdministratorEmailAddress());
            uc.next();
            User sysadmin = uc.getUser();
            Assert.assertNotNull(sysadmin);
            uc.close();
    
            return sysadmin;
        }
        
        /**
         * Returns a list of at most numUsers BigDecimal User ID's
         * @param numUsers at most the number of User ID's to return 
         * @return a List of BigDecimal User ID's
         */
        public static List getUsersIDs(int numUsers) {
            UserCollection users = User.retrieveAll();
            users.setRange(new Integer(1), new Integer(numUsers+1));
            
            ArrayList list = new ArrayList(numUsers);
            while (users.next()) {
                list.add(users.getUser().getID());       
            }
                            
            users.close();            
            return list;
        }
}
