/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.util.*;
import java.util.*;
import java.io.*;
import org.apache.commons.cli.*;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/packaging/Which.java#4 $
 */
class Which extends Command {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/packaging/Which.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(Which.class);

    private static final Options OPTIONS = getOptions();

    public Which() {
        super("which", "Find a resource or class in the CCM classpath");
    }

    // XXX The following two methods are duplicated from Checklist.
    // Need to find a good place for this functionality.

    private static List getClassURLs(final String classname) {
        return getResourceURLs(classname.replace('.', '/') + ".class");
    }

    private static List getResourceURLs(final String resource) {
        final ArrayList list = new ArrayList();

        try {
            final Enumeration resources = Thread.currentThread
                ().getContextClassLoader().getResources(resource);

            while (resources.hasMoreElements()) {
                list.add(resources.nextElement());
            }
        } catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }

        return list;
    }

    public boolean run(final String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        } catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }

        if (line.hasOption("usage")) {
            usage(OPTIONS, System.out, "RESOURCES");
            return true;
        }

        String[] names = line.getArgs();

        if (names.length == 0) {
            usage(OPTIONS, System.err, "RESOURCES");
            return false;
        }

        for (int i = 0; i < names.length; i++) {
            String name = names[i];
            final Iterator classes = getClassURLs(name).iterator();

            while (classes.hasNext()) {
                System.out.println(classes.next());
            }

            final Iterator resources = getResourceURLs(name).iterator();

            while (resources.hasNext()) {
                System.out.println(resources.next());
            }
        }

        return true;
    }

}
