/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.runtime.CCM;
import java.io.*;
import java.util.*;
import java.util.Set;

import org.apache.commons.cli.*;

/**
 * Unload
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

class Unload extends Command {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Unload.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Options OPTIONS = new Options();

    static {
        OPTIONS.addOption
            (OptionBuilder
             .hasArg(false)
             .withLongOpt("config")
             .withDescription("Unload configuration")
             .create());
    }

    private static final Set EXCLUDE = new HashSet();

    static {
        EXCLUDE.add("resin.conf");
        EXCLUDE.add("resin.pid");
        EXCLUDE.add("server.xml");
    }

    public Unload() {
        super("unload", "Unload configuration");
    }

    public boolean run(String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        } catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }

        String[] packages = line.getArgs();
        if (packages.length == 0) {
            usage(OPTIONS, System.err);
            return false;
        }

        if (line.hasOption("config")) {
            // XXX: This just deletes everything.
            File conf = CCM.getConfigDirectory();
            File[] files = conf.listFiles(new FileFilter() {
                public boolean accept(File file) {
                    return !EXCLUDE.contains(file.getName());
                }
            });

            for (int i = 0; i < files.length; i++) {
                Files.delete(files[i]);
            }
        }

        return true;
    }

}
