/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.runtime.CCM;
import com.arsdigita.util.*;
import com.arsdigita.util.parameter.*;

import java.io.*;
import java.util.*;

/**
 * Config
 *
 * This class is <strong>not</strong> supported API.
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

public final class Config extends ParameterMap {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Config.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private ConfigRegistry m_reg;

    public Config(ConfigRegistry reg) {
        m_reg = reg;

        for (Iterator it = m_reg.getContexts().iterator(); it.hasNext(); ) {
            Class klass = (Class) it.next();
            ParameterContext context =
                (ParameterContext) Classes.newInstance(klass);
            addContext(context);
        }
    }

    void load(ErrorList errs) {
        for (Iterator it = getContexts().iterator(); it.hasNext(); ) {
            ParameterContext ctx = (ParameterContext) it.next();
            m_reg.load(ctx, errs);
        }
    }

    public final boolean load(PrintStream out) {
        ErrorList errs = new ErrorList();
        load(errs);
        if (!errs.isEmpty()) {
            out.println(" *** Warning ***");
            errs.report(new OutputStreamWriter(out));
            return false;
        }

        return true;
    }

    public final void save() throws IOException {
        save(CCM.getConfigDirectory());
    }

    void save(File conf) throws IOException {
        if (!conf.exists()) {
            throw new IOException("no such directory: " + conf);
        }

        if (conf.isFile()) {
            throw new IOException("expecting directory: " + conf);
        }

        if (!conf.canWrite()) {
            throw new IOException("cannot write to directory: " + conf);
        }

        HashMap stores = new HashMap();
        for (Iterator it = getContexts().iterator(); it.hasNext(); ) {
            ParameterContext ctx = (ParameterContext) it.next();
            String storage = m_reg.getStorage(ctx.getClass());
            Properties props = (Properties) stores.get(storage);
            if (props == null) {
                props = new Properties();
                stores.put(storage, props);
            }

            ctx.save(new JavaPropertyWriter(props));
        }

        for (Iterator it = stores.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry me = (Map.Entry) it.next();
            String storage = (String) me.getKey();
            Properties props = (Properties) me.getValue();
            if (props.size() == 0) { continue; }
            File file = new File(conf, storage);
            File dir = file.getParentFile();
            dir.mkdirs();
            if (!(dir.exists() && dir.isDirectory())) {
                throw new IOException("unable to create directory: " + dir);
            }
            try {
                FileOutputStream out = new FileOutputStream(file);
                props.store
                    (out, " Generated by " + getClass().getName());
                out.close();
            } catch (IOException e) {
                throw new IOException
                    ("unable to save file: " + e.getMessage());
            }
        }
    }

}
