/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mimetypes;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;

/**
 * A textual mime-type
 *
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 *
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class TextMimeType extends MimeType {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/TextMimeType.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.cms.TextMimeType";

    public static final String IS_INSO = "isInso";

    public static final String TEXT_PREFIX = "text";

    public static final String MIME_TEXT_HTML = "text/html";

    /**
     * Load an existing <code>TextMimeType</code>.
     */
    public TextMimeType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    /**
     * Construct a new <code>TextMimeType</code> from the given {@link DataObject}.
     * All subclasses must implement this constructor.
     */
    public TextMimeType(DataObject obj) {
        super(obj);
    }

    /**
     * Construct a new <code>MimeType</code> with a given object type.
     * All subclasses must implement this constructor.
     */
    public TextMimeType(String type, String mimeType) {
        super(type, mimeType);
    }

    /**
     * Return the base data object type for this mime-type
     */
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    /**
     * Return true if mimeType can be converted to HTML
     * using inso filter.
     *
     * @return true if the mime type can be converted, false otherwise
     */
    public Boolean allowINSOConvert() {
        return (Boolean)get(IS_INSO);
    }

    /**
     * Set whether mimeType can be converted to HTML
     * using inso filter.
     *
     * @param canConvert true if the mime type can be converted, false otherwise
     */
    public void setAllowINSOConvert(Boolean canConvert) {
        set(IS_INSO, canConvert);
    }

    /**
     * Set whether mimeType can be converted to HTML
     * using inso filter.
     *
     * @param canConvert true if the mime type can be converted, false otherwise
     */
    public void setAllowINSOConvert(boolean canConvert) {
        setAllowINSOConvert((canConvert)?Boolean.TRUE:Boolean.FALSE);
    }

}
