/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mimetypes;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;

/**
 * This class contains a collection of MimeTypes.
 *
 * @author <a href="mailto:flattop@arsdigita.com">Jack Chung</a>
 * @version 1.0
 * @see com.arsdigita.domain.DomainCollection
 * @see com.arsdigita.persistence.DataCollection
 */
public class MimeTypeCollection extends DomainCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/MimeTypeCollection.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     **/
    public MimeTypeCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Set the order of this Collection. This method needs to be called
     * before <code>next()</code> is called on this collection.
     *
     */
    public void addOrder(String order) {
        m_dataCollection.addOrder(order);
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     **/
    public DomainObject getDomainObject() {
        return new MimeType(m_dataCollection.getDataObject());
    }

    /**
     * Returns a <code>MimeType</code> for the current position in
     * the collection.
     *
     **/
    public MimeType getMimeType() {
        return ((MimeType) getDomainObject()).specialize();
    }

}
