/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mimetypes;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;

/**
 * A mime type for images.
 *
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class ImageMimeType extends MimeType {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/ImageMimeType.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.cms.ImageMimeType";

    public static final String SIZER_CLASS = "sizerClass";

    public static final String MIME_IMAGE_JPEG = "image/jpeg";

    /**
     * Load an existing <code>ImageMimeType</code>.
     */
    public ImageMimeType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    /**
     * Construct a new <code>ImageMimeType</code> from the given {@link DataObject}.
     * All subclasses must implement this constructor.
     */
    public ImageMimeType(DataObject obj) {
        super(obj);
    }

    /**
     * Construct a new <code>MimeType</code> with a given object type.
     * All subclasses must implement this constructor.
     */
    public ImageMimeType(String type, String mimeType) {
        super(type, mimeType);
    }

    /**
     * Return the base data object type for this mime-type
     */
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    /**
     * Return the name of the image sizer class for this mime-type.
     * The image sizer class can be used to guess the width and height
     * (in pixels) of an image. The class will be a subclass of
     * <code>com.arsdigita.cms.image.ImageSizer</code>
     *
     * @return the name of the class which handles image sizing for
     *   this mime type on success, null if the mime type is not an
     *   image or if its size cannot be automatically guessed
     */
    public String getImageSizer() {
        return (String)get(SIZER_CLASS);
    }

    /**
     * Set the name of the image sizer class for this mime type.
     *
     * @param imageSizerClassName the name of the Java class which will
     *   handle image sizing for this mime type
     * @see #getImageSizer
     */
    public void setImageSizer(String imageSizerClassName) {
        set(SIZER_CLASS, imageSizerClassName);
    }

    /**
     * Get all image mime-types in the system
     */
    public static MimeTypeCollection getAllImageMimeTypes() {
        DataCollection da = SessionManager.getSession().retrieve
            (BASE_DATA_OBJECT_TYPE);
        return new MimeTypeCollection(da);
    }

}
