/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.ui;

import com.arsdigita.kernel.Resource;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.PageState;
import org.apache.log4j.Logger;

/**
 * <p>A base class used to implement the UI callbacks on {@link
 * com.arsdigita.kernel.ResourceTypeConfig}.</p>
 *
 * A component for advanced configuration of a resource.
 * The subclass should take whatever steps are required to
 * accumulate configuration info, and then fire a completion
 * event. Upon receiving the completion event, the container
 * of this component will then invoke the createResource
 * or modifyResource methods to persist the changes.
 *
 * @see com.arsdigita.kernel.ResourceTypeConfig
 * @see com.arsdigita.web.ApplicationType
 * @see com.arsdigita.web.Application
 * @author Daniel Berrange &lt;<a href="mailto:berrange@redhat.com">berrange@redhat.com</a>&gt;
 */
public class ResourceConfigComponent extends SimpleContainer {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/kernel/ui/ResourceConfigComponent.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ResourceConfigComponent.class);

    public ResourceConfigComponent() {
        super();
    }

    public ResourceConfigComponent(String name,
                                   String xmlns) {
        super(name,
              xmlns);
    }

    /**
     * This method is only called on ResourceConfigFormSections
     * that have been retrieved through the getCreateFormSection
     * method on ResourceTypeConfig. The application should be
     * initialized, but not saved.
     */
    public Resource createResource(PageState ps) {
        throw new UnsupportedOperationException();
    }

    /**
     * This method is only called on ResourceConfigFormSections
     * that have been retrieved through the getModifyFormSection
     * method on ResourceTypeConfig. The application modified is
     * the one specified in the RequestLocal argument to the
     * getModifyFormSection method.  The application can be modified
     * and saved, but it does not have to be saved.
     */
    public void modifyResource(PageState ps) {
        throw new UnsupportedOperationException();
    }
}
