/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.kernel.Party;

import com.arsdigita.persistence.OID;

/**
 * Represents a permission that applies universally to all objects.
 *
 * @author Oumi Mehrotra 
 * @version 1.0
 *
 * @see com.arsdigita.kernel.permissions.PermissionDescriptor
 * @see com.arsdigita.kernel.permissions.PrivilegeDescriptor
 * @see com.arsdigita.kernel.permissions.PermissionService
 **/
public class UniversalPermissionDescriptor extends PermissionDescriptor {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/UniversalPermissionDescriptor.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    static final OID ROOT_CONTEXT_OID =
        new OID("com.arsdigita.kernel.ACSObject", 0);

    /**
     * Creates a new UniversalPermissionDescriptor object for the specified party.
     *
     * @param privilege the privilege that is to be universal
     *
     * @param party the party that this privilege is to be universally granted to
     *
     * @see com.arsdigita.kernel.ACSObject
     * @see com.arsdigita.kernel.Party
     * @see com.arsdigita.kernel.permissions.PrivilegeDescriptor
     **/
    public UniversalPermissionDescriptor(PrivilegeDescriptor privilege, Party party) {
        this(privilege, (party == null) ? (OID) null : party.getOID());
    }

    /**
     * Creates a new UniversalPermissionDescriptor object for the party with the specified OID.
     *
     * @param privilege the privilege descriptor that is to be universal
     *
     * @param partyOID the OID of the party this this privilege
     * is to be universally granted to
     *
     * @see com.arsdigita.kernel.ACSObject
     * @see com.arsdigita.kernel.Party
     * @see com.arsdigita.kernel.permissions.PrivilegeDescriptor
     * @see com.arsdigita.persistence.OID
     **/
    public UniversalPermissionDescriptor(PrivilegeDescriptor privilege, OID partyOID) {
        super(privilege, ROOT_CONTEXT_OID, partyOID);
    }
}
