/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.kernel.security.SecurityLogger;

import org.apache.log4j.Priority;

/**
 * PermissionException
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 **/

public class PermissionException extends RuntimeException {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/PermissionException.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private PermissionDescriptor m_permission;
    private String m_msg;

    /**
     * Used for permission failures because of no authenticated party.
     **/
    public PermissionException(PrivilegeDescriptor priv, ACSObject obj) {
        m_permission = null;
        m_msg = "Unauthenticated party does not have the " + priv +
            " privilege on Object " + obj.getOID() + ".";
        SecurityLogger.log(Priority.WARN, m_msg);
    }

    public PermissionException(PermissionDescriptor permission) {
        m_permission = permission;

        OID partyOID = m_permission.getPartyOID();
        String userID = partyOID == null ? null : "" + partyOID.get("id");
        String priv = m_permission.getPrivilegeDescriptor().getDisplayName();
        String objectID = "" + m_permission.getACSObjectOID().toString();

        String contextID = null;
        DataObject context = PermissionService.getContext(
            m_permission.getACSObjectOID()
        );

        if ( context != null ) {
            contextID = context.getOID().toString();
        }

        m_msg = "User " + userID + " does not have the " + priv + " privilege " +
            " on Object " + objectID + " with context " + contextID;


        SecurityLogger.log(Priority.WARN, m_msg);
    }

    public PermissionException(PrivilegeDescriptor priv, 
                               ACSObject obj, 
                               String message) {
        m_permission = null;
        m_msg = "Permission denied. Attempted operation using " + 
            priv + " on Object " + obj.getOID() + ": " + message;
        SecurityLogger.log(Priority.WARN, m_msg);
    }

    public PermissionDescriptor getPermission() {
        return m_permission;
    }

    public String getMessage() {
        return m_msg;
    }

}
