/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;


import com.arsdigita.persistence.DataCollection;


/**
 * Represents a collection of parties.
 *
 * @author Phong Nguyen 
 * @version 1.0
 **/
public class UserCollection extends PartyCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/UserCollection.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     * @see PartyCollection#PartyCollection(DataCollection)
     **/
    public UserCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns the screen name for this user.
     *
     * @return the screen name.
     **/
    public String getScreenName() {
        return (String) m_dataCollection.get("screenName");
    }

    /**
     * Wrapper to <code>getDomainObject()</code> that casts the returned
     * <code>DomainObject</code> as a <code>User</code>.
     *
     * @return a <code>User</code> for the current position in the
     * collection.
     *
     * @see #getDomainObject()
     * @see User
     * @see com.arsdigita.domain.DomainObject
     **/
    public User getUser() {
        return (User) getDomainObject();
    }

}
