/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;


/**
 * An interface for listening to the events of a package listener.
 * Package Listeners are registered according to PackageTypes using
 * the <code>addListener()</code> method.
 *
 * <font color="ff0000">
 * Note: The APIs for this class have not been reviewed and are
 * subject to change after review.
 * </font>
 *
 * @see PackageType#addListener
 * @version $Revision: #6 $, $Date: 2004/04/07 $
 * @since ACS 5.0
 */
public interface PackageEventListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/PackageEventListener.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Called when a package instance is mounted on a
     * siteNode.
     *
     * @param siteNode the SiteNode where the instance is mounted
     * @param pkg the instance being mounted
     */
    public void onMount(SiteNode siteNode, PackageInstance pkg);

    /**
     * Called when a package instance is unmounted from a
     * siteNode.
     *
     * @param siteNode the SiteNode where the instance is mounted
     * @param pkg the instance being unmounted
     */
    public void onUnmount(SiteNode siteNode, PackageInstance pkg);


    /**
     * Called when a new package instance is created.
     *
     * @param pkg a PackageInstance value
     */
    public void onCreate(PackageInstance pkg);

    /**
     * Describe onDelete method here.
     *
     * @param pkg a PackageInstance value
     */
    public void onDelete(PackageInstance pkg);

}
