/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.DataCollection;

/**
 * Represents a collection of groups.
 *
 * @author Phong Nguyen
 * @version 1.0
 **/
public class GroupCollection extends PartyCollection {
    public static final String versionId = 
        "$Id: //core-platform/dev/src/com/arsdigita/kernel/GroupCollection.java#8 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     * @see PartyCollection#PartyCollection(DataCollection)
     **/
    public GroupCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns the name of this group.
     *
     * @return the name of this group.
     **/
    public String getName() {
        return (String) m_dataCollection.get("name");
    }

    /**
     * Wrapper to <code>getDomainObject()</code> that casts the returned
     * <code>DomainObject</code> as a <code>Group</code>.
     *
     * @return a <code>Group</code> for the current position in the
     * collection.
     *
     * @see #getDomainObject()
     * @see Group
     **/
    public Group getGroup() {
        return (Group) getDomainObject();
    }
}
