/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * <p>
 * Provides Locale of the client application.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class ClientLocaleProvider implements LocaleProvider {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/ClientLocaleProvider.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private String m_targetBundle = "";
    private String m_acceptLanguages = "";

    public Locale getLocale() {
        ResourceBundle b = null;
        Locale l = null;

        if (m_acceptLanguages.length() > 0) {

            AcceptField[] af =
                (new AcceptLanguageHeader(m_acceptLanguages)).getAcceptFields();

            for (int i = 0; i < af.length; i++) {
                l = ((AcceptLanguage) af[i]).getLocale();

                // Get the ResourceBundle for this Locale. Don't let the
                // search fallback to match other languages.
                SystemLocaleProvider slp = (SystemLocaleProvider)
                    LocaleNegotiator.getSystemLocaleProvider();
                Locale defaultLocale = null;
                if (slp != null) {
                    defaultLocale = slp.getLocale();
                }
                if (defaultLocale == null) {
                    defaultLocale = Locale.getDefault();
                }

                b = Globalization.getBundleNoFallback(
                                                      m_targetBundle, l, defaultLocale
                                                      );

                if (b != null) {
                    break;
                }
            }

            if (b == null) {
                l = ((AcceptLanguage) af[0]).getLocale();
            }
        }

        return l;
    }

    public void setTargetBundle(String targetBundle) {
        m_targetBundle =
            (targetBundle != null) ? targetBundle : "";
    }

    public void setAcceptLanguages(String acceptLanguages) {
        m_acceptLanguages =
            (acceptLanguages != null) ? acceptLanguages : "";
    }
}
