/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import java.util.Arrays;
import java.util.StringTokenizer;

/**
 * <p>
 * Abstract class, manages Accept HTTP headers as defined in RFC 2616.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public abstract class AcceptHeader {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/AcceptHeader.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // as passed in by the client browser.
    protected String m_acceptHeader = "";

    // our representation.
    protected AcceptField[] m_acceptFields = null;

    public AcceptField[] getAcceptFields() {
        return m_acceptFields;
    }

    protected void setAcceptFields() {
        StringTokenizer tokenizer =
            new StringTokenizer(m_acceptHeader, ",");

        AcceptField[] afArr = new AcceptField[tokenizer.countTokens()];

        int i = 0;
        AcceptField af = null;
        while (tokenizer.hasMoreTokens()) {
            af = createAcceptField(tokenizer.nextToken());

            if (af.getQValue() > 0) {
                afArr[i++] = af;
            }
        }

        m_acceptFields = new AcceptField[i];
        System.arraycopy(afArr, 0, m_acceptFields, 0, i);

        Arrays.sort(m_acceptFields);
    }

    abstract protected AcceptField createAcceptField(String acceptField);
}
