/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.util;

import com.arsdigita.util.StringUtils;

import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;


import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterData;

import java.util.HashMap;
import java.util.Iterator;


import com.arsdigita.db.Sequences;
import java.sql.SQLException;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class Placeholders {

    private HashMap m_vars;

    // FIXME: why do we need to pass state into this constructor? I don't see it
    // used anywhere. -- 2002-11-26
    public Placeholders(PageState state) {
        User user = (User)Kernel.getContext().getParty();

        m_vars = new HashMap();

        if (user != null) {
            setUserVars(user);
        }
        setSystemVars();
    }

    // FIXME: why do we need to pass state into this constructor? I don't see it
    // used anywhere. -- 2002-11-26
    public Placeholders(PageState state, FormData data) {
        User user = (User)Kernel.getContext().getParty();

        m_vars = new HashMap();

        if (user != null) {
            setUserVars(user);
        }
        setFormVars(data);
        setSystemVars();
    }


    public String interpolate(String text) {
        return StringUtils.interpolate(text, m_vars);
    }

    public void setVariable(String key,
                            String value) {
        m_vars.put(key, value);
    }

    protected void setUserVars(User user) {
        PersonName name = user.getPersonName();

        m_vars.put("user.givenname", name.getGivenName());
        m_vars.put("user.familyname", name.getFamilyName());
        m_vars.put("user.screenname", user.getScreenName());
        m_vars.put("user.email", user.getPrimaryEmail().getEmailAddress());
    }

    protected void setFormVars(FormData data) {
        // XXX uncomment this code when (if) we move to acs 4.6.9

        Iterator params = data.getParameters().iterator();
        while(params.hasNext()) {
            ParameterData param = (ParameterData)params.next();
	    Object value = param.getValue();
            m_vars.put("form." + param.getName(), (value == null ? "(null)" : value.toString()));
        }

        /*
          Iterator keys = data.keySet().iterator();
          while (keys.hasNext()) {
          String key = (String)keys.next();
          Object value = data.get(key);

          m_vars.put("form." + key, (value == null ? "(null)" : value.toString()));
          }
        */
    }

    protected void setSystemVars() {
        m_vars.put("system.uniqueid", new UniqueIDGenerator());
    }

    private class UniqueIDGenerator implements StringUtils.PlaceholderValueGenerator {
        public String generate(String key) {
            BigDecimal id;
            try {
                id = Sequences.getNextValue("forms_unique_id_seq");
            } catch (SQLException e) {
                throw new UncheckedWrapperException(e);
            }
            return id.toString();
        }
    }
}
