/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


// Every item in the list will have links
import com.arsdigita.bebop.Link;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListCellRenderer;

// Every item in the list will be a BoxPanel
import com.arsdigita.bebop.BoxPanel;
// The BoxPanel is a Container
import com.arsdigita.bebop.Container;
// The ListCellRenderer produces components
import com.arsdigita.bebop.Component;

// Never really used, but in some method signatures
import com.arsdigita.bebop.PageState;


/**
 * A list of all persisted SimpleQuestionnaires with links to viewing, editing
 * properties and editing widget setup for each quesionnaire in the list. Applications
 * that want to reuse this list might want to use a different cell renderer by invoking
 * setCellRenderer().
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/SimpleQuestionnaireList.java#7 $
 */
public class SimpleQuestionnaireList extends List {

    public SimpleQuestionnaireList() {
        super(getListModelBuilder());

        setCellRenderer(getFormBuilderDefaultRenderer());
    }

    private static ListModelBuilder getListModelBuilder() {

        return new ListModelBuilder() {
                public ListModel makeModel(List l, PageState pageState) {
                    return new SimpleQuestionnaireListModel();
                }

                public void lock() {
                    // This ListModelBuilder has nothing to lock :-)
                }

                public boolean isLocked() {
                    return true;
                }
            };

    }

    private ListCellRenderer getFormBuilderDefaultRenderer() {

        // Use a renderer that outputs a view link and two edit links per item
        return new ListCellRenderer() {

                // These variables are just temporary storage
                // to let me share data across methods
                private Container m_item;
                private String m_formID;

                public Component getComponent(List list,
                                              PageState state,
                                              Object value,
                                              String key,
                                              int index,
                                              boolean isSelected) {

                    // I want to have three links horizontally aligned, namely
                    // a view link, an edit form properties link and an edit widgets link
                    m_item = new BoxPanel(BoxPanel.HORIZONTAL);
                    m_formID = key;

                    // The view form link
                    addLink(value.toString(),
                            FormViewPage.instance().getRelativeURL());

                    // The edit properties link
                    Link editLink = new Link("Edit properties",
                                             FormPropertiesPage.instance().getRelativeURL());
                    editLink.setVar(FormBuildingPage.instance().m_formID.getName(),
                                    m_formID);
                    editLink.setVar(FormPropertiesPage.instance().m_pageMode.getName(),
                                    "edit");
                    m_item.add(editLink);

                    // Link to the edit widget composition page
                    Link widgetLink = getBaseLink("Edit widget setup",
                                                  FormBuildingPage.instance().getRelativeURL());
                    widgetLink.setVar(FormBuildingPage.instance().m_pageMode.getName(),
                                      "view");
                    m_item.add(widgetLink);

                    return m_item;
                }

                private void addLink(String label, String url) {

                    m_item.add(getBaseLink(label, url));
                }

                private Link getBaseLink(String label, String url) {

                    Link link = new Link(label, url);
                    link.setVar(FormBuildingPage.instance().m_formID.getName(),
                                m_formID);

                    return link;
                }
            };
    }
}
