/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.event.PrintListener;
import java.math.BigDecimal;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.PersistentFormSection;
import java.util.TooManyListenersException;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;

public class NewSection extends Form {
    private SingleSelectionModel m_form;
    private SingleSelect m_sections;

    public NewSection(SingleSelectionModel form) {
        super("new_section");

        m_form = form;

        FormSection fs = new FormSection(new BoxPanel(BoxPanel.HORIZONTAL));

        m_sections = new SingleSelect(new BigDecimalParameter("section"));
        m_sections.addValidationListener
            (new NotNullValidationListener
             (GlobalizationUtil.globalize("formbuilder.ui.form_section_null_error")));
        fs.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.add_new")));
        fs.add(m_sections);
        fs.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.form_section")));
        fs.add(new Submit("Add"));

        add(fs);
    }

    public BigDecimal getSelectedSection(PageState state) {
        return (BigDecimal)m_sections.getValue(state);
    }

    // XXX PrintListener will change to ListModel when (if)
    // optiongroups finally become model driven
    public void setFormSectionModelBuilder(PrintListener l) {
        try {
            m_sections.addPrintListener(l);
        } catch (TooManyListenersException ex) {
            throw new UncheckedWrapperException("Cannot set form model", ex);
        }
    }

    public void generateXML(PageState state, Element parent) {
        BigDecimal form_id = (BigDecimal)m_form.getSelectedKey(state);
        PersistentFormSection form = (PersistentFormSection)FormBuilderUtil.instantiateObject(form_id);

        setVisible(state, form instanceof PersistentForm ? true : false);

        super.generateXML(state, parent);
    }
}
