/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 

import com.arsdigita.formbuilder.MetaObject;
import com.arsdigita.formbuilder.MetaObjectCollection;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;

import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;


import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Page;
import com.arsdigita.formbuilder.PersistentComponent;



public class NewControl extends Form {
    ParameterSingleSelectionModel m_selection;
    SingleSelect m_type;

    public NewControl(String app) {
        super("new_control");

        FormSection fs = new FormSection(new BoxPanel(BoxPanel.HORIZONTAL));

        fs.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.add_new")));

        m_selection = new ParameterSingleSelectionModel(new BigDecimalParameter("type"));

        m_type = new SingleSelect(m_selection.getStateParameter());
        loadComponents(app);

        fs.add(m_type);
        fs.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.form_widget")));
        fs.add(new Submit("Create"));

        addInitListener(new NewControlInitListener());

        add(fs);
    }

    public void register(Page page) {
        super.register(page);
        page.addComponentStateParam(this,
                                    m_selection.getStateParameter());
    }

    protected void loadComponents(String app) {
        try {
            MetaObjectCollection objects = MetaObject.getWidgets(app,
                                                                 PersistentComponent.class);
            objects.addOrder(MetaObject.PRETTY_NAME);

            while (objects.next()) {
                MetaObject control = objects.getMetaObject();

                m_type.addOption(new Option(control.getID().toString(),
                                            control.getPrettyName()));
            }
        } catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException(ex);
        }
    }

    public SingleSelectionModel getSelection() {
        return m_selection;
    }

    private class NewControlInitListener implements FormInitListener {
        public void init(FormSectionEvent e)
            throws FormProcessException {

            // FIXME: what is the point of this method? -- 2002-11-26

            // BigDecimal type = (BigDecimal)m_selection.getSelectedKey(e.getPageState());

            //m_type.setOptionSelected(type.toString());
        }
    }
}
