/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 


import com.arsdigita.formbuilder.FormBuilderDispatcher;

import com.arsdigita.formbuilder.util.FormBuilderUtil;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.parameters.BigDecimalParameter;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;

import java.math.BigDecimal;

import com.arsdigita.bebop.PageState;

import com.arsdigita.formbuilder.SimpleQuestionnaire;

// To make the title dynamic
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.PrintEvent;


/**
 * This Page displays a form that has been
 * persisted.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/FormViewPage.java#9 $
 *
 */
public class FormViewPage extends TemplatePage {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/FormViewPage.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static FormViewPage s_instance;

    // State parameters
    private BigDecimalParameter m_formID;

    private RequestLocal m_questionnaire = new RequestLocal() {
            public Object initialValue(PageState pageState) {

                SimpleQuestionnaire questionnaire;
                try {
                    questionnaire =
                        new SimpleQuestionnaire(FormViewPage.this.getFormID(pageState));
                } catch(DataObjectNotFoundException notFoundException) {
                    throw new UncheckedWrapperException(notFoundException);
                }

                return questionnaire;
            }
        };

    private FormViewPage() {
        super(getStaticTitle());
    }

    /**
     * Provide access to the single instance of this page.
     */
    public static FormViewPage instance() {

        if (s_instance == null) {
            s_instance = new FormViewPage();
        }

        return s_instance;
    }

    /**
     * This method builds the Component structure specific to a certain Page
     * in the Form Builder service.
     */
    protected void buildPage() {

        m_formID = new BigDecimalParameter("form_id");
        addGlobalStateParam(m_formID);

        add(FormBuilderUtil.createIndexLink());

        setDynamicTitle();

        add(new PreviewForm(false,
                            new FormConnector()));

        add(FormBuilderUtil.createIndexLink());
    }

    private class FormConnector implements PreviewFormPageConnector {

        public SimpleQuestionnaire getQuestionnaire(PageState pageState) {

            return FormViewPage.this.getQuestionnaire(pageState);
        }
    }

    private void setDynamicTitle() {

        // Make the title show the admin name of the form
        Label titleLabel = new Label(GlobalizationUtil.globalize("formbuilder.ui.view_persisted_form"));
        titleLabel.addPrintListener(
                                    new PrintListener() {
                                        public void prepare(PrintEvent e) {
                                            Label inner_titleLabel = (Label)e.getTarget();
                                            PageState pageState = e.getPageState();

                                            SimpleQuestionnaire questionnaire =
                                                FormViewPage.this.getQuestionnaire(pageState);

                                            String adminName = questionnaire.getAdminName();

                                            inner_titleLabel.setLabel("View Persisted Form \"" + adminName + "\"");
                                        }
                                    }
                                    );
        setTitle(titleLabel);
    }

    public BigDecimal getFormID(PageState pageState) {

        return (BigDecimal)pageState.getValue(m_formID);
    }

    /**
     * This method returns the request independent title of
     * this Page.
     */
    public static String getStaticTitle() {
        return "View a Persisted Form";
    }

    public String getRelativeURL() {
        return "view-form"  + FormBuilderDispatcher.getURLEnding();
    }

    private SimpleQuestionnaire getQuestionnaire(PageState pageState) {

        return (SimpleQuestionnaire)m_questionnaire.get(pageState);
    }
}
