/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.PrintEvent;


/**
 * This hidden will grab the form id from the URL and
 * put it in a Hidden widget to be added to forms so
 * that the form id is not lost from request to request.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/FormIDHidden.java#7 $
 *
 */
public class FormIDHidden extends Hidden {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/FormIDHidden.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public FormIDHidden() {
        super("form_id");

        try {
            addPrintListener(
                             new PrintListener() {
                                 public void prepare(PrintEvent printEvent) {
                                     Hidden hidden = (Hidden)printEvent.getTarget();

                                     // Get the form id from the URL if possible
                                     String urlFormID = printEvent.getPageState().getRequest().getParameter("form_id");

                                     // Set the form id if there was any in the URL
                                     if (urlFormID != null && !urlFormID.equals("")) {
                                         hidden.setValue(printEvent.getPageState(), urlFormID);
                                     }
                                 }
                             }

                             );
        } catch (java.util.TooManyListenersException e) {
            throw new com.arsdigita.util.UncheckedWrapperException(e);
        }
    }
}
