/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.AbstractSingleSelectionModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import java.math.BigDecimal;
import com.arsdigita.bebop.SingleSelectionModel;


public class DecimalSingleSelectionModel extends AbstractSingleSelectionModel {

    private SingleSelectionModel m_selection;

    public DecimalSingleSelectionModel(SingleSelectionModel selection) {
        m_selection = selection;
    }

    public boolean isSelected(PageState state) {
        return m_selection.isSelected(state);
    }

    public Object getSelectedKey(PageState state) {
        Object obj = m_selection.getSelectedKey(state);
        return obj == null ? null : new BigDecimal((String)obj);
    }

    public void setSelectedKey(PageState state,
                               Object key) {
        m_selection.setSelectedKey(state,
                                   (key == null ? null :
                                    key.toString()));
    }

    public void clearSelection(PageState state) {
        m_selection.clearSelection(state);
    }

    public void addChangeListener(ChangeListener l) {
        // XXX broken event source
        m_selection.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        // XXX broken event source
        m_selection.removeChangeListener(l);
    }

    public ParameterModel getStateParameter() {
        return m_selection.getStateParameter();
    }
}
