/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.actions;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormSectionEvent;

import com.arsdigita.formbuilder.PersistentProcessListener;

import java.math.BigDecimal;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.util.UncheckedWrapperException;

public class ConfirmRedirectListener extends PersistentProcessListener {
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.actions.ConfirmRedirectListener";

    public static final String URL = "url";

    public ConfirmRedirectListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ConfirmRedirectListener(String typeName) {
        super(typeName);
    }

    public ConfirmRedirectListener(ObjectType type) {
        super(type);
    }

    public ConfirmRedirectListener(DataObject obj) {
        super(obj);
    }

    public ConfirmRedirectListener(BigDecimal id)
        throws DataObjectNotFoundException {

        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public ConfirmRedirectListener(OID oid)
        throws DataObjectNotFoundException {

        super(oid);
    }

    public static ConfirmRedirectListener create(String name,
                                                 String description,
                                                 String url) {
        ConfirmRedirectListener l = new ConfirmRedirectListener();

        l.setup(name, description, url);

        return l;
    }

    protected void setup(String name,
                         String description,
                         String url) {
        super.setup(name, description);
        set(URL, url);
    }

    // XXX hack to get around some wierd issues
    // with mdsql associations where the object
    // type in question is a subtype of the
    // one named in the association definition
    public boolean isContainerModified() {
        return false;
    }


    public String getUrl() {
        return (String)get(URL);
    }

    public void setUrl(String url) {
        set(URL, url);
    }

    public FormProcessListener createProcessListener() {
        return new ConfirmRedirectProcessListener(getUrl());
    }

    private class ConfirmRedirectProcessListener implements FormProcessListener {
        String m_url;

        public ConfirmRedirectProcessListener(String url) {
            m_url = url;
        }

        public void process(FormSectionEvent e)
            throws FormProcessException {

            try {
                DispatcherHelper.sendExternalRedirect(e.getPageState().getResponse(), m_url);
            } catch (java.io.IOException ex) {
                throw new UncheckedWrapperException("Cannot do redirect", ex);
            }
        }
    }
}
