/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.actions;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormSectionEvent;

import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.util.Placeholders;

import java.math.BigDecimal;
import com.arsdigita.formbuilder.util.Placeholders;
import com.arsdigita.mail.Mail;
import javax.mail.MessagingException;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.util.UncheckedWrapperException;


public class ConfirmEmailListener extends PersistentProcessListener {
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.actions.ConfirmEmailListener";

    public static final String FROM = "from";
    public static final String SUBJECT = "subject";
    public static final String BODY = "body";

    public ConfirmEmailListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ConfirmEmailListener(String typeName) {
        super(typeName);
    }

    public ConfirmEmailListener(ObjectType type) {
        super(type);
    }

    public ConfirmEmailListener(DataObject obj) {
        super(obj);
    }

    public ConfirmEmailListener(BigDecimal id)
        throws DataObjectNotFoundException {

        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public ConfirmEmailListener(OID oid)
        throws DataObjectNotFoundException {

        super(oid);
    }


    public static ConfirmEmailListener create(String name,
                                              String description,
                                              String from,
                                              String subject,
                                              String body) {
        ConfirmEmailListener l = new ConfirmEmailListener();
        l.setup(name, description, from, subject, body);
        return l;
    }

    protected void setup(String name,
                         String description,
                         String from,
                         String subject,
                         String body) {
        super.setup(name, description);
        set(FROM, from);
        set(SUBJECT, subject);
        set(BODY, body);
    }

    // XXX hack to get around some wierd issues
    // with mdsql associations where the object
    // type in question is a subtype of the
    // one named in the association definition
    public boolean isContainerModified() {
        return false;
    }

    public String getFrom() {
        return (String)get(FROM);
    }

    public void setFrom(String from) {
        set(FROM, from);
    }

    public String getSubject() {
        return (String)get(SUBJECT);
    }

    public void setSubject(String subject) {
        set(SUBJECT, subject);
    }

    public String getBody() {
        return (String)get(BODY);
    }

    public void setBody(String body) {
        set(BODY, body);
    }

    public FormProcessListener createProcessListener() {
        return new ConfirmEmailProcessListener(getFrom(),
                                               getSubject(),
                                               getBody());
    }

    private class ConfirmEmailProcessListener implements FormProcessListener {
        String m_from;
        String m_subject;
        String m_body;

        public ConfirmEmailProcessListener(String from,
                                           String subject,
                                           String body) {
            m_from = from;
            m_subject = subject;
            m_body = body;
        }

        public void process(FormSectionEvent e)
            throws FormProcessException {

            Placeholders p = new Placeholders(e.getPageState(),
                                              e.getFormData());

            String from = p.interpolate(m_from);
            String subject = p.interpolate(m_subject);
            String body = p.interpolate(m_body);
            //String to = p.interpolate("::user.givenname:: ::user.familyname:: <::user.email::>");
            String to = p.interpolate("::user.email::");

            try {
                Mail message = new Mail(to, from, subject, body);
                message.send();
            } catch (MessagingException ex) {
            throw new UncheckedWrapperException("cannot send message", ex);
            }
        }
    }
}
