/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


// The class that we are making persistent
import com.arsdigita.bebop.form.Select;

// All ACSObjects have a unique id
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;

// Every PersistentComponentFactory can create a Bebop Component
import com.arsdigita.bebop.Component;

// Thrown if the underlying DataObject with given id cannot be found
import com.arsdigita.domain.DataObjectNotFoundException;


/**
 * This class is responsible for persisting Bebop Selects. The Select
 * is saved with the save() method. To resurrect the Select, use the constructor
 * taking the id of the saved Select and then invoke createComponent().
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentSelect.java#9 $
 *
 */
public abstract class PersistentSelect extends PersistentOptionGroup {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentSelect.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    /**
     * BASE_DATA_OBJECT_TYPE represents the full name of the
     * underlying DataObject of this class.
     */
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.Widget";

    // *** Constructors -------------

    /**
     * Constructor that creates a new Select domain object that
     * can be saved to the database later on.
     */
    public PersistentSelect(String objectType) {

        super(objectType);
    }


    public PersistentSelect(ObjectType type) {
        super(type);
    }

    public PersistentSelect(DataObject obj) {
        super(obj);
    }

    /**
     * Extending classes can use this constructor to set the sub class
     * id and object type.
     */
    public PersistentSelect(OID oID)
        throws DataObjectNotFoundException {

        super(oID);
    }


    /**
     * Create a sub class of Select. This method
     * must be implemented by sub clases.
     */
    public abstract Component createComponent();


    protected void addDataToComponent(Component component) {

        super.addDataToComponent(component);

        Select select = (Select)component;

        if (getComponentAttribute("size") != null) {
            select.setSize(getSize());
        }
    }

    // *** Attribute Methods

    /**
     * The HTML Size attribute of this widget
     */
    public void setSize(int size) {

        setComponentAttribute("size", Integer.toString(size));
    }

    /**
     * The HTML Size attribute of this widget
     */
    public int getSize() {

        return Integer.parseInt(getComponentAttribute("size"));
    }
}
