/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;

import com.arsdigita.kernel.ACSObject;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.bebop.event.FormProcessListener;

import com.arsdigita.formbuilder.util.FormBuilderUtil;

import java.math.BigDecimal;

public class PersistentProcessListener extends ACSObject {

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.ProcessListener";

    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String LISTENER_CLASS = "listenerClass";

    public PersistentProcessListener(String typeName) {
        super(typeName);
    }

    public PersistentProcessListener(ObjectType type) {
        super(type);
    }

    public PersistentProcessListener(BigDecimal id)
        throws DataObjectNotFoundException {

        this (new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public PersistentProcessListener(OID oid)
        throws DataObjectNotFoundException {

        super(oid);
    }

    public PersistentProcessListener(DataObject obj) {
        super(obj);
    }

    public static PersistentProcessListener create(String name,
                                                   String className) {
        PersistentProcessListener listener =
            new PersistentProcessListener(BASE_DATA_OBJECT_TYPE);

        listener.setName(name);
        listener.setProcessListenerClass(className);

        return listener;
    }

    protected void setup(String name,
                         String description) {
        set(NAME, name);
        set(DESCRIPTION, description);
    }

    /**
     * This default implementation will instantiate an instance of the listener
     * of the process listener class given in the constructor.
     */
    public FormProcessListener createProcessListener() {

        return (FormProcessListener)FormBuilderUtil.instantiateObject((String)get(LISTENER_CLASS));
    }

    public void setName(String name) {
        set(NAME, name);
    }

    public String getName() {
        return (String)get(NAME);
    }

    public void setProcessListenerClass(String className) {

        set(LISTENER_CLASS, className);
    }

    public String getPrcoessListenerClass() {

        return (String)get(LISTENER_CLASS);
    }

    public void setDescription(String desc) {
        set(DESCRIPTION, desc);
    }

    public String getDescription() {
        return (String)get(DESCRIPTION);
    }
}
