/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class MetaObjectCollection extends DomainCollection {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/MetaObjectCollection.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected MetaObjectCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Get the ID for the portal for the current row.
     *
     * @return the id of this portal.
     * @post return != null
     */
    public BigDecimal getID() {
        BigDecimal id = (BigDecimal)m_dataCollection.get("id");

        Assert.assertNotNull(id);

        return id;
    }

    /**
     * Get the current item as a domain object.
     *
     * @return the domain object for the current row.
     * @post return != null
     */
    public DomainObject getDomainObject() {
        DomainObject domainObject = getMetaObject();

        Assert.assertNotNull(domainObject);

        return domainObject;
    }

    /**
     * Get the current item as a MetaObject domain object.
     *
     * @return a MetaObject domain object.
     * @post return != null
     */
    public MetaObject getMetaObject() {
        DataObject dataObject = m_dataCollection.getDataObject();

        MetaObject obj = MetaObject.retrieve(dataObject);

        Assert.assertNotNull(obj);

        return obj;
    }
}
