/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

/**
 * <code>ObjectNotFoundException</code> is the runtime exception that
 * is thrown whenever an object we depend on to execute a workflow
 * suddenly disappears.  This may be because another user deleted it,
 * for instance.
 *
 * @author Justin Ross (jross@redhat.com)
 * @version $Id: //core-platform/dev/src/com/arsdigita/dispatcher/ObjectNotFoundException.java#7 $
 */
public class ObjectNotFoundException extends RuntimeException {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/ObjectNotFoundException.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    // The default error detail message.
    private final static String ERROR_MSG = "The object requested cannot be found";

    public ObjectNotFoundException() {
        this(ERROR_MSG);
    }

    /**
     * Constructs an ObjectNotFoundException with the specified detail message.
     *
     * @param msg The error detail message
     */
    public ObjectNotFoundException(String msg) {
        super(msg);
    }
}
