/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import javax.servlet.http.HttpServletRequest;


/**
 * <tt>AccessDeniedException</tt> is the runtime exception that is thrown
 * whenever the current user does not have access to the requested resources.
 *
 * @author Michael Pih 
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class AccessDeniedException extends RuntimeException {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/AccessDeniedException.java#8 $ $Author: dennis $ $DateTime";

    public final static String ACCESS_DENIED =
        "com.arsdigita.cms.dispatcher.AccessDeniedException";


    // The default error detail message.
    private final static String ERROR_MSG = "Access Denied";

    // The URL where the AccessDeniedException is thrown.
    private String m_url;


    /**
     * Constructs an AccessDeniedException with the default detail message.
     */
    public AccessDeniedException() {
        this(ERROR_MSG);
    }

    /**
     * Constructs an AccessDeniedException with the specified detail message.
     *
     * @param msg The error detail message
     */
    public AccessDeniedException(String msg) {
        super(msg);

        // Try and fetch the current request URL.
        HttpServletRequest request = DispatcherHelper.getRequest();
        if  ( request != null ) {
            m_url = DispatcherHelper.getRequest().getRequestURI();
            request.setAttribute(ACCESS_DENIED, m_url);
        } else {
            m_url = null;
        }
    }

    /**
     * Fetches the URL where the AccessDeniedException originated.
     *
     * @return The original URL
     */
    public String getOriginalURL() {
        return m_url;
    }

}
