/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.categorization;

import com.arsdigita.kernel.ui.DataQueryTreeModel;
import com.arsdigita.kernel.ui.DataQueryTreeNode;
import com.arsdigita.kernel.ui.DataQueryTreeIterator;
import org.apache.log4j.Logger;

/**
 * Implements the {@link com.arsdigita.bebop.tree.TreeModel} interface for
 * categories.
 *
 * @author Daniel Berrange
 * @version $Revision: #16 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class CategoryTreeModelLite extends DataQueryTreeModel {
    private static final Logger s_log =
        Logger.getLogger(CategoryTreeModelLite.class);

    String m_order = null;

    /**
     * Initializes with the passed in the root Category.
     *
     * @param rootCategory the root category for this TreeModel
     */
    public CategoryTreeModelLite(Category root) {
        this(root,null);
    }
    /**
     * Initializes with the passed in the root Category.
     *
     * @param rootCategory the root category for this TreeModel
     * @param order the field to order by
     */
    public CategoryTreeModelLite(Category root, String order) {
        super(root.getID(),
              "com.arsdigita.categorization.getRootCategory",
              "com.arsdigita.categorization.getSubCategories");
        m_order = order;
    }

    protected DataQueryTreeIterator getDataQueryTreeIterator
        (DataQueryTreeNode node, String getSubCategories) {
        return new CategoryTreeIterator(node, getSubCategories, m_order);
    }

    private static class CategoryTreeIterator extends DataQueryTreeIterator {
        public CategoryTreeIterator(DataQueryTreeNode node, String getSubCategories, String order) {
            super(node,getSubCategories);
            if (order != null) {
                addOrder(order);
            }
        }
        public Object next() {
            DataQueryTreeNode node = (DataQueryTreeNode)super.next();
            
            //                    m_nodes.getLink
            node.setValue( Category.IS_ABSTRACT,
                           (Boolean)m_nodes.get(Category.IS_ABSTRACT));
            return node;
        }

    }
}
