/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.table;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.util.LockableImpl;

/**
 * A convenience for implementing <code>TableModelBuilder</code>s. This
 * class provides a default implementation of the methods demanded by
 * <code>Lockable</code>, so that implementors of
 * <code>TableModelBuilder</code> only need to override the
 * <code>makeModel</code> method.
 *
 * @author David Lutterkort
 * @see TableModelBuilder
 * @see com.arsdigita.util.Lockable
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/table/AbstractTableModelBuilder.java#7 $
 */
public abstract class AbstractTableModelBuilder extends LockableImpl
    implements TableModelBuilder {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/table/AbstractTableModelBuilder.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Return a table model for the request represented by
     * <code>s</code>. The table model contains all the data that is to be
     * displayed in a table. The returned table model is used only during
     * the duration of that request.
     *
     * @param t the table which will use this table model
     * @param s represents the current request
     * @return the data to be displayed in the table
     */
    public abstract TableModel makeModel(Table t, PageState s);

}
