/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 *     Verifies that the
 *    parameter's value is not null.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Stas Freidin 
 *    @author Rory Solomon 
 */
public class NotNullValidationListener extends GlobalizedParameterListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/NotNullValidationListener.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final NotNullValidationListener DEFAULT = new NotNullValidationListener();

    public NotNullValidationListener(String title) {
        setError(new GlobalizedMessage(title, getBundleBaseName()));
    }

    public NotNullValidationListener() {
        setError(new GlobalizedMessage(
                                       "parameter_is_required", getBundleBaseName()
                                       ));
    }

    public NotNullValidationListener(GlobalizedMessage error) {
        setError(error);
    }

    public void validate (ParameterEvent e) {
        ParameterData data = e.getParameterData();
        Object value = data.getValue();

        if (value != null && value.toString().length() > 0) {
            return;
        }

        data.addError(getError());
    }
}
