/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.globalization.Globalized;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 * <p>
 * Abstract class to be extended by globalized parameters.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public abstract class GlobalizedParameterListener
    implements Globalized, ParameterListener {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/GlobalizedParameterListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static String BUNDLE_NAME =
        "com.arsdigita.bebop.parameters.ParameterResources";

    private GlobalizedMessage m_error = null;

    /**
     * <p>
     * Return the base name of the target ResourceBundle.
     * </p>
     *
     * @return String target ResourceBundle base name.
     */
    public String getBundleBaseName() {
        return BUNDLE_NAME;
    }

    /**
     * <p>
     * Get the error message for this parameter.
     * </p>
     *
     * @return GlobalizedMessage The error.
     */
    protected GlobalizedMessage getError() {
        return m_error;
    }

    /**
     * <p>
     * Set the error message for this parameter.
     * </p>
     *
     * @param error The error message to use for this parameter.
     */
    protected void setError(GlobalizedMessage error) {
        m_error = error;
    }
}
