/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.list;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Component;

/**
 * Produce a component to output one item in a
 * <code>List</code>. For example, to output the item either as a link
 * that, when clicked, will make the item selected or, if the item is
 * selected will display it as a bold label, you would write the following
 * code:
 *
 * <pre>
 * public class MyListCellRenderer implements ListCellRenderer {
 *
 *   public Component getComponent(List list, PageState state, Object value,
 *                                 String key, int index, boolean isSelected) {
 *     Label l = new Label(value.toString());
 *     if (isSelected) {
 *       l.setFontWeight(Label.BOLD);
 *       return l;
 *     }
 *     return new ControlLink(l);
 *   }
 * }
 * </pre>
 * This is actually exactly what the {@link DefaultListCellRenderer} does.
 *
 * @see List
 * @see DefaultListCellRenderer
 * @see ListModel
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/list/ListCellRenderer.java#9 $ */
public interface ListCellRenderer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/list/ListCellRenderer.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Return a component that has been configured to display the specified
     * value. That component's <code>generateXML</code> or <code>print</code>
     * method is then called to "render" the cell.
     *
     * @param list the <code>List</code> in which this item is being displayed.
     * @param state represents the state of the current request.
     * @param value the value returned by
     * <code>list.getModel(state).getElement()</code>
     * @param key the value returned by
     * <code>list.getModel(state).getKey()</code>
     * @param index the number of the item in the list
     * @param isSelected true is the item is selected
     * @return the component used to generate the output for the list item
     * @pre list != null
     * @pre state |= null
     * @pre value != null
     * @pre key != null
     * @post return != null
     */
    Component getComponent(List list, PageState state, Object value,
                           String key, int index, boolean isSelected);
}
